import {useDispatch, useSelector} from "react-redux";
import {useEffect, useState} from "react";
import {useParams} from "react-router";
import {ApplicationActions} from "../../redux/actions/applicationActions";
import {ApplicationDetailsModal} from "./ApplicationDetailsModal";
import "./Applications.css"
import Select from "react-select";
import {sortElementsBy} from "../../utils/utils";
import {JobSeekerActions} from "../../redux/actions/JobSeekerActions";
import {notifyAppStatusUpdate} from "../../utils/toastUtils";

export const ApplicationsByJobAd = () => {

    const dispatch = useDispatch();
    let {advertisement_id} = useParams();

    const [applicationsByJobAd, setApplicationsByJobAd] = useState([]);
    let applicationsByJobAdState = useSelector(state => state.appl.applicationsByJobAdId)
    const [dispatched, setDispatched] = useState(false);

    const [profilePics, setProfilePics] = useState({});
    let profilePicsState = useSelector(state => state.images.profilePictures)
    const [profilePicsDispatched, setProfilePicsDispatched] = useState(false);

    const [jobAdTitle, setJobAdTitle] = useState("");

    useEffect(() => {
        if(!dispatched && (applicationsByJobAdState.length === 0 || applicationsByJobAdState.length === 1)) {
            dispatch(ApplicationActions.fetchApplicationsByJobAdId(advertisement_id, (success, reponse) => {
                if (success && reponse.data.length > 0) {
                    setApplicationsByJobAd(sortElementsBy(reponse.data, "submittedOn"))
                    setJobAdTitle(reponse.data[0].jobAdTitle)
                }
                setDispatched(true)
                console.log("Fetch applications by job ad GET")
            }))
        } else {
            setApplicationsByJobAd(sortElementsBy(applicationsByJobAdState, "submittedOn"));
            if(applicationsByJobAdState.length > 0) {
                setJobAdTitle(applicationsByJobAdState[0].jobAdTitle)
            }

        }

    }, [applicationsByJobAdState])

    useEffect(() => {
        if(dispatched && !profilePicsDispatched) {
            applicationsByJobAd.forEach(app => {
                if(app.jobSeekerId && !profilePics[app.jobSeekerId]) {
                    fetchProfilePic(app.jobSeekerId)
                }
            })
            setProfilePicsDispatched(true);
            console.log("Fetch all profile pics GET")
        } else if(profilePicsDispatched) {
            setProfilePics(profilePicsState)
            console.log("Fetch all profile pics STATE")
        }
    }, [dispatched])

    const fetchProfilePic = (jobSeekerId) => {
        dispatch(JobSeekerActions.downloadProfilePic(jobSeekerId, (success, response) => {
            if(success) {
                setProfilePics(prevState => ({...prevState, [jobSeekerId]: response}))
            }
        }))
    }


    const options = [
        {value: 'PROPOSED', label: <span><i className="fa-solid fa-paper-plane"></i> Proposed</span>},
        {value: 'UNDER_REVIEW', label: <span><i className="fa-solid fa-file-pen"></i> Under Review</span>},
        {value: 'ACCEPTED', label: <span><i className="fa-solid fa-user-check"></i> Accepted</span>},
        {value: 'DENIED', label: <span><i className="fa-solid fa-user-slash"></i> Denied</span>}
    ];

    let handleDefaultStatus = (status) => {
        return options.find(option => option.value === status);
    }

    let handleChangeStatus = (selectedOption, id) => {
        dispatch(ApplicationActions.updateApplicationStatus(id, selectedOption.value, (success, response) => {
            if(success) {
                // console.log("Status updated.")
                notifyAppStatusUpdate()
            }
        }))
    }


    return (<div className="custom-container">
        <div className="application-title">
            {jobAdTitle ?
                <h3>Applications for <b>{jobAdTitle}</b></h3> :
                <h1></h1>
            }
        </div>

        {applicationsByJobAd && applicationsByJobAd.map((application, index) => (
            <div className="application-card">
                <div className="app-job-seeker-pic">
                    <img
                        // loading gif
                        src={profilePicsState[application.jobSeekerId]}
                        alt=""
                        width={75} height={75}
                    />
                </div>
                <div className="app-info">
                    <span>Submitted on <b>{new Date(application.submittedOn).toLocaleString('default', {
                        day: 'numeric',
                        month: 'long',
                        year: 'numeric'
                    })}</b></span>
                    <div className="contact-info">
                        <div className="contact-item">
                            <i className="fa-solid fa-user"></i> <span>{application.jobSeekerName}</span>
                        </div> <div className="contact-item">
                            <i className="fa-solid fa-envelope"></i> <span>{application.jobSeekerEmail}</span>
                        </div> <div className="contact-item">
                            <i className="fa-solid fa-phone"></i> <span>{application.jobSeekerPhoneNumber}</span>
                        </div>
                    </div>
                </div>

                <div className="app-status">
                    <ApplicationDetailsModal application={application}/>
                    <div className="select">
                        <Select options={options}  onChange={(selectedOption) => handleChangeStatus(selectedOption, application.id)} defaultValue={handleDefaultStatus(application.status)}/>
                    </div>

                </div>
            </div>
       ))}

    </div>)
}