package mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.users;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.enumerations.Role;

@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "recruiters")
public class Recruiter extends User {

    public Recruiter(String email, String password, String companyName, String phoneNumber) {
        this.email = email;
        this.password = password;
        this.companyName = companyName;
        this.companyDescription = "";
        this.phoneNumber = phoneNumber;
        this.role = Role.ROLE_RECRUITER;
    }

    @Column(name = "company_name")
    private String companyName;

    @Column(name = "company_description")
    private String companyDescription;

    @Column(name = "phone_number")
    private String phoneNumber;

    @Override
    public String getName() {
        return companyName;
    }
}
