import logo from './logo.svg';
import './App.css';
import {useDispatch} from "react-redux";
import {BrowserRouter} from "react-router-dom";
import {Header} from "./views/static/Header";
import {RoutesConfig} from "./auth/RoutesConfig";
import {useEffect} from "react";
import {AuthActions} from "./redux/actions/authActions";
import {AUTH_TOKEN} from "./axios/axiosInstance";

function App() {
    const dispatch = useDispatch();

    useEffect(() => {
        dispatch(AuthActions.updateToken(localStorage.getItem(AUTH_TOKEN)))
    }, [dispatch])

  return (
      <div className="App">
          <BrowserRouter>
              <Header/>
              <RoutesConfig/>
          </BrowserRouter>
      </div>
  );
}

export default App;
