#!/bin/bash

# Test Docker setup script
echo "🧪 Testing Kupi.mk Docker setup..."

# Test if containers are running
if docker-compose ps | grep -q "Up"; then
    echo "✅ Containers are running"
else
    echo "❌ Containers are not running"
    exit 1
fi

# Test backend health
echo "🔍 Testing backend..."
if curl -f http://localhost:5001/api/products > /dev/null 2>&1; then
    echo "✅ Backend is responding"
else
    echo "❌ Backend is not responding"
fi

# Test frontend
echo "🔍 Testing frontend..."
if curl -f http://localhost:3000 > /dev/null 2>&1; then
    echo "✅ Frontend is accessible"
else
    echo "❌ Frontend is not accessible"
fi

# Test database
echo "🔍 Testing database..."
if docker-compose exec -T postgres pg_isready -U admin -d kupi_mk > /dev/null 2>&1; then
    echo "✅ Database is ready"
else
    echo "❌ Database is not ready"
fi

echo "🎉 Docker setup test completed!"