# Kupi.mk - E-commerce платформа за Македонија

Модерна e-commerce платформа изградена со Node.js, React и PostgreSQL, специјално дизајнирана за македонскиот пазар.

## 🚀 Карактеристики

- 👤 Корисничка автентикација (регистрација/најава)
- 📦 Управување со производи (CRUD операции)
- 🖼️ Upload и приказ на слики
- 🏷️ Категоризација на производи
- 👨‍💼 Кориснички профили со управување производи
- 🎨 Модерен UI на македонски јазик
- 📱 Responsive дизајн
- 🔒 Безбедност со JWT токени

## 🛠️ Технологии

### Backend
- **Node.js** - JavaScript runtime
- **Express.js** - Web framework
- **PostgreSQL** - База на податоци
- **JWT** - Автентикација
- **Multer** - File upload
- **bcryptjs** - Password hashing

### Frontend
- **React** - UI библиотека
- **React Router** - Навигација
- **Tailwind CSS** - CSS framework
- **Axios** - HTTP client
- **Context API** - State management

## 📋 Предуслови

Пред да го стартувате проектот, треба да имате инсталирано:

- [Node.js](https://nodejs.org/) (v14 или понова)
- [PostgreSQL](https://www.postgresql.org/) (v12 или понова)
- [Git](https://git-scm.com/)

## 🚀 Инсталација и поставување

### 1. Clone на репозиториумот
```bash
git clone https://github.com/yourusername/kupi-mk.git
cd kupi-mk
```

### 2. Поставување на базата на податоци

#### За Linux/Mac:
```bash
# Стартувај PostgreSQL сервис
sudo service postgresql start

# Поврзи се како postgres корисник
sudo -u postgres psql

# Во PostgreSQL shell:
CREATE USER kupi_user WITH PASSWORD 'kupi123';
CREATE DATABASE kupi_mk OWNER kupi_user;
GRANT ALL PRIVILEGES ON DATABASE kupi_mk TO kupi_user;
\q
```

#### За Windows:
```cmd
# Отвори Command Prompt како Administrator
# Стартувај PostgreSQL сервис (ако не е веќе стартуван)
net start postgresql-x64-13

# Поврзи се со psql
psql -U postgres

# Во PostgreSQL shell:
CREATE USER kupi_user WITH PASSWORD 'kupi123';
CREATE DATABASE kupi_mk OWNER kupi_user;
GRANT ALL PRIVILEGES ON DATABASE kupi_mk TO kupi_user;
\q
```

### 3. Backend Setup
```bash
cd kupi-mk/backend

# Инсталирај dependencies
npm install

# Копирај и конфигурирај .env файл
cp .env.example .env

# Уреди .env файл со твоите податоци
# За Windows: copy .env.example .env

# Стартувај backend сервер
npm run dev
```

### 4. Frontend Setup
```bash
# Отвори нов terminal/command prompt
cd kupi-mk/frontend

# Инсталирај dependencies
npm install

# Стартувај frontend сервер
npm start
```

## 🌐 Пристапување до апликацијата

- **Frontend**: http://localhost:3000
- **Backend API**: http://localhost:5000

## 📁 Структура на проектот

```
kupi-mk/
├── backend/                 # Node.js/Express backend
│   ├── config/             # Database конфигурација
│   ├── middleware/         # Express middleware
│   ├── routes/             # API routes
│   ├── uploads/            # Uploaded слики
│   ├── server.js           # Главен server файл
│   └── package.json
├── frontend/               # React frontend
│   ├── public/            # Статички файлови
│   ├── src/
│   │   ├── components/    # React компоненти
│   │   ├── pages/         # Страници
│   │   ├── context/       # React Context
│   │   └── services/      # API сервиси
│   └── package.json
└── README.md
```

## 🔧 Development команди

### Backend:
```bash
npm run dev          # Стартувај со nodemon (auto-restart)
npm start           # Стартувај production сервер
```

### Frontend:
```bash
npm start           # Стартувај development сервер
npm run build       # Build за production
npm test            # Пушти тестови
```

## 🐛 Troubleshooting

### PostgreSQL Connection Issues:
1. Провери дали PostgreSQL сервисот е стартуван
2. Провери ги credentials во .env файлот
3. Провери дали базата `kupi_mk` постои

### Port Conflicts:
- Backend default: порт 5000
- Frontend default: порт 3000
- Промени ги во .env (backend) или package.json (frontend)

### Windows Specific:
- Користи `npm run dev` наместо `sudo` команди
- Користи Command Prompt или PowerShell како Administrator за PostgreSQL setup

## 👥 Contributing

1. Fork the project
2. Create your feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 👨‍💻 Author

**Aleksandar Grozdanoski**
- GitHub: [@yourusername](https://github.com/yourusername)
- Email: aleksandar.grozdanoski@students.finki.ukim.mk

### Backend
- **Node.js** са Express.js
- **PostgreSQL** база на податоци
- **JWT** за автентикација
- **Multer** за upload на слики
- **bcryptjs** за хаширање на лозинки

### Frontend
- **React.js** 
- **Tailwind CSS** за стилизирање
- **React Router** за навигација
- **Axios** за API повици
- **Context API** за state management

## Карактеристики

✅ **Автентикација на корисници**
- Регистрација и најавување
- JWT токени
- Заштитени рути

✅ **Управување со производи**
- Преглед на производи со пагинација
- Детален приказ на секој производ
- Креирање на нови производи
- Upload на повеќе слики

✅ **Филтрирање и пребарување**
- Пребарување по наслов и опис
- Филтрирање по категории
- Брза навигација по категории

✅ **Профил на корисници**
- Личен профил
- Преглед на сопствени производи
- Информации за продавачи

## Покренување на проектот

### Предуслови
- Node.js (v14+)
- PostgreSQL база на податоци
- npm или yarn

### VS Code Tasks (препорачано)
1. **Отвори го проектот** во VS Code
2. **Покрени ги двата сервери**:
   - Backend: `Ctrl+Shift+P` → "Tasks: Run Task" → "Start Backend Server"
   - Frontend: `Ctrl+Shift+P` → "Tasks: Run Task" → "Start Frontend Server"
3. **Отвори** http://localhost:3000 во прелистувач

### Мануелно покренување

```bash
# Backend
cd kupi-mk/backend
npm install
npm run dev

# Frontend (во нов терминал)
cd kupi-mk/frontend  
npm install
npm start
```

### Конфигурација на базата
Уредете ги податоците во `backend/.env`:
```env
DB_HOST=localhost
DB_PORT=5432
DB_NAME=kupi_mk
DB_USER=your_username
DB_PASSWORD=your_password
JWT_SECRET=your_secret_key
```

Табелите ќе се креираат автоматски при првото поврзување.
