# 🎯 Quick Database Setup Guide

## For Windows Users (Recommended Path)

### Option 1: Automatic Setup (Easiest) 🚀

```
📁 Your Project Folder
├── 📜 setup-database-windows.bat    ← Double-click this!
├── 📜 setup-database-windows.ps1    ← Or run this in PowerShell
└── 📄 WINDOWS_DATABASE_SETUP.md     ← Detailed guide
```

**Just double-click `setup-database-windows.bat` and follow the prompts!**

### Option 2: Manual Setup 🔧

1. **Download PostgreSQL** 
   - Go to: https://www.postgresql.org/download/windows/
   - Download the installer
   - Run as Administrator

2. **During Installation**
   - Set postgres password (remember it!)
   - Keep default port (5432)
   - Install all components

3. **Run Our Setup Script**
   - Double-click `setup-database-windows.bat`
   - Enter your postgres password when prompted

## For Linux/Mac Users 🐧🍎

### Automatic Setup
```bash
cd kupi-mk
chmod +x start-servers.sh
./start-servers.sh
```

### Manual Setup
```bash
# Install PostgreSQL (if not installed)
sudo apt install postgresql postgresql-contrib  # Ubuntu/Debian
# or
brew install postgresql  # macOS

# Create database
sudo -u postgres psql
CREATE DATABASE kupi_mk;
CREATE USER kupi_user WITH PASSWORD 'kupi_password';
GRANT ALL PRIVILEGES ON DATABASE kupi_mk TO kupi_user;
\q
```

## ✅ Verification Steps

After setup, you should see:

1. **PostgreSQL running** ✓
2. **Database created** ✓
3. **User created** ✓
4. **Connection test passed** ✓
5. **.env file created** ✓

## 🚀 Start the Application

### Windows:
```cmd
start-servers-windows.bat
```

### Linux/Mac:
```bash
./kupi-mk/start-servers.sh
```

### VS Code (All platforms):
1. `Ctrl+Shift+P` → "Tasks: Run Task"
2. Select "Start Backend Server"
3. Select "Start Frontend Server"

## 🌐 Access Your Application

- **Frontend**: http://localhost:3000
- **Backend API**: http://localhost:5000
- **Network**: http://192.168.100.162:3000 (for other devices)

## ❓ Need Help?

1. **Windows users**: See `WINDOWS_DATABASE_SETUP.md`
2. **Connection issues**: Check if PostgreSQL service is running
3. **Port conflicts**: Make sure ports 3000 and 5000 are free
4. **Password issues**: Try the setup script again

## 🔧 Manual Configuration

If automatic setup fails, create `.env` file in `kupi-mk/backend/`:

```env
DB_HOST=localhost
DB_PORT=5432
DB_NAME=kupi_mk
DB_USER=kupi_user
DB_PASSWORD=kupi_password
JWT_SECRET=your_secret_key_here
PORT=5000
NODE_ENV=development
```

---

**Most users can just run `setup-database-windows.bat` and be done in 2 minutes!** 🎉
