#!/bin/bash

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${YELLOW}Stopping Kupi.mk Development Servers...${NC}"
echo ""

# Stop all node processes related to the project
echo -e "${YELLOW}Stopping Node.js processes...${NC}"
pkill -f "npm run dev" 2>/dev/null
pkill -f "npm start" 2>/dev/null
pkill -f "node.*server.js" 2>/dev/null
pkill -f "react-scripts" 2>/dev/null

# Wait a moment for processes to terminate
sleep 2

# Check if any node processes are still running
REMAINING=$(pgrep -f "npm|node.*kupi-mk" 2>/dev/null | wc -l)

if [ $REMAINING -eq 0 ]; then
    echo -e "${GREEN}All servers have been stopped successfully.${NC}"
else
    echo -e "${RED}Some processes may still be running. You may need to stop them manually.${NC}"
    echo -e "${YELLOW}Running processes:${NC}"
    pgrep -f "npm|node.*kupi-mk" -l 2>/dev/null || echo "None found"
fi

# Clean up log files
if [ -f "../backend.log" ]; then
    rm ../backend.log
    echo -e "${GREEN}Cleaned up backend.log${NC}"
fi

if [ -f "../frontend.log" ]; then
    rm ../frontend.log
    echo -e "${GREEN}Cleaned up frontend.log${NC}"
fi

echo ""
