import React from 'react';
import { useCart } from '../context/CartContext';

const CartIcon = ({ onClick }) => {
  const { totalItems, loading } = useCart();

  return (
    <button
      onClick={onClick}
      className="relative inline-flex items-center px-3 py-2 text-gray-700 hover:text-blue-600 transition-colors duration-200"
      aria-label={`Shopping cart with ${totalItems} items`}
    >
      {/* Shopping Cart Icon */}
      <svg
        className="w-6 h-6"
        fill="none"
        stroke="currentColor"
        viewBox="0 0 24 24"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          strokeLinecap="round"
          strokeLinejoin="round"
          strokeWidth={2}
          d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l1.5-6M17 13l1.5 6M9 19.5h6"
        />
      </svg>

      {/* Cart Item Count Badge */}
      {totalItems > 0 && (
        <span className="absolute -top-1 -right-1 bg-red-500 text-white text-xs font-bold rounded-full h-5 w-5 flex items-center justify-center min-w-[20px] animate-pulse">
          {totalItems > 99 ? '99+' : totalItems}
        </span>
      )}

      {/* Loading indicator */}
      {loading && (
        <div className="absolute -top-1 -right-1 w-4 h-4">
          <div className="animate-spin rounded-full h-4 w-4 border-2 border-blue-500 border-t-transparent"></div>
        </div>
      )}

      {/* Cart text (optional, can be hidden on mobile) */}
      <span className="ml-2 hidden sm:inline-block font-medium">
        Cart
      </span>
    </button>
  );
};

export default CartIcon;