// Dynamic API configuration that works on any device
const getServerBaseUrl = () => {
  // In production, use environment variable or default
  if (process.env.NODE_ENV === 'production') {
    return process.env.REACT_APP_API_URL?.replace('/api', '') || 'http://localhost:5000';
  }

  // In development, automatically detect the correct IP
  const hostname = window.location.hostname;
  
  if (hostname === 'localhost' || hostname === '127.0.0.1') {
    // If accessing via localhost, use localhost for API too
    return 'http://localhost:5000';
  } else {
    // If accessing via network IP, use the same IP for API
    return `http://${hostname}:5000`;
  }
};

export const SERVER_BASE_URL = getServerBaseUrl();
export const API_BASE_URL = `${SERVER_BASE_URL}/api`;

// Debug logging
console.log('🔧 Dynamic API Configuration:');
console.log(`  Current hostname: ${window.location.hostname}`);
console.log(`  SERVER_BASE_URL: ${SERVER_BASE_URL}`);
console.log(`  API_BASE_URL: ${API_BASE_URL}`);

export const getImageUrl = (imagePath) => {
  if (!imagePath) return '/placeholder-image.svg';
  
  // If it's already a full URL, return as is
  if (imagePath.startsWith('http')) return imagePath;
  
  // If it starts with /, add the backend URL
  if (imagePath.startsWith('/')) {
    return `${SERVER_BASE_URL}${imagePath}`;
  }
  
  // Otherwise assume it's a relative path
  return `${SERVER_BASE_URL}/uploads/products/${imagePath}`;
};
