<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\Order;

class PaymentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Ensure at least one order exists
        if (Order::count() === 0) {
            $this->command->warn('No orders found. Creating a dummy order first.');

            $order = Order::create([
                'id' => Str::uuid(),
                'customer_id' => Str::uuid(), // adjust if you have customer relation
                'order_date' => now(),
                'status' => 'pending',
                // add any other required fields from your orders migration
            ]);
        } else {
            $order = Order::inRandomOrder()->first();
        }

        // Example payment data
        $payments = [
            [
                'id' => Str::uuid(),
                'order_id' => $order->id,
                'amount' => 1500.00,
                'currency' => 'USD',
                'due_date' => now()->addDays(30),
                'exchange_rate' => 1.0,
                'payment_date' => null,
                'payment_method' => 'bank_transfer',
                'payment_status' => 'pending',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => Str::uuid(),
                'order_id' => $order->id,
                'amount' => 2000.00,
                'currency' => 'EUR',
                'due_date' => now()->addDays(15),
                'exchange_rate' => 1.1,
                'payment_date' => now()->addDays(5),
                'payment_method' => 'credit_card',
                'payment_status' => 'completed',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('payments')->insert($payments);
    }
}
