<?php

namespace Database\Factories;

use App\Models\Buyer;
use App\Models\Receiver;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Order>
 */
class OrderFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model = Order::class;
    public function definition(): array
    {
        $statuses = ['pending', 'processing', 'shipped', 'delivered'];
        $date = $this->faker->dateTimeBetween('-30 days', 'now');
        $estimatedDelivary = $this->faker->dateTimeBetween($date, '+30 days');
        return [
            'buyer_id' => Buyer::factory(),
            'receiver_id' => Receiver::factory(),
            'transport_id' => Transport::factory(),
            'date' => $date,
            'status' => $this->faker->randomElement($statuses),
            'estimated_delivery_date' => $estimatedDelivary,
        ];
    }

    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'pending',
        ]);
    }
    public function delivered(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'delivered',
        ]);
    }
}
