<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Models\Order;
use App\Models\Product;
use App\Models\Batch;

class OrderBatchSeeder extends Seeder
{
    public function run(): void
    {
        $orders = Order::all();
        $products = Product::all();

        if ($orders->isEmpty() || $products->isEmpty()) {
            $this->command->warn('No orders or products found.');
            return;
        }

        foreach ($orders as $order) {
            // pick 1-3 random products for this order
            $picked = $products->random(rand(1, min(3, $products->count())));
            foreach ($picked as $product) {
                // choose batches for this product
                $batches = Batch::where('product_id', $product->id)->inRandomOrder()->get();
                if ($batches->isEmpty()) continue;
                // allocate a total quantity for this product in order
                $remainingQty = rand(100, 10000); // number of units to ship for this product
                foreach ($batches as $batch) {
                    if ($remainingQty <= 0) break;
                    // take between 1 and min(remainingQty, 5000)
                    $take = rand(1, min($remainingQty, 5000));
                    // insert into order_batches (we include UUID for id)
                    DB::table('order_batches')->insert([
                        'id' => (string)Str::uuid(),
                        'order_id' => $order->id,
                        'batch_id' => $batch->id,
                        'quantity' => $take,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                    $remainingQty -= $take;
                }
            }
        }

        $this->command->info('Order batches seeded.');
    }
}
