<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Inertia\Inertia;

class CrudController extends Controller
{
    protected function resolveModel(string $model)
    {
        $class = 'App\\Models\\' . Str::studly(Str::singular($model));

        if (!class_exists($class)) {
            abort(404, "Model [$class] not found.");
        }

        return new $class;
    }

    public function index(Request $request, string $model)
    {
        $instance = $this->resolveModel($model);

        $items = $instance->query()->paginate(10);
        $fields = $instance->getFillable();

        return Inertia::render('Crud/Index', [
            'model' => $model,
            'items' => $items,
            'fields' => $fields,
        ]);
    }

    public function create(string $model)
    {
        $instance = $this->resolveModel($model);

        return Inertia::render('Crud/Form', [
            'model' => $model,
            'fields' => $instance->getFillable(),
            'item' => null,
        ]);
    }

    public function store(Request $request, string $model)
    {
        $instance = $this->resolveModel($model);

        $data = $request->validate(
            array_fill_keys($instance->getFillable(), 'required')
        );

        $instance->create($data);

        return redirect()->route('crud.index', $model);
    }

    public function edit(string $model, $id)
    {
        $instance = $this->resolveModel($model)->findOrFail($id);

        return Inertia::render('Crud/Form', [
            'model' => $model,
            'fields' => $instance->getFillable(),
            'item' => $instance,
        ]);
    }

    public function update(Request $request, string $model, $id)
    {
        $instance = $this->resolveModel($model)->findOrFail($id);

        $data = $request->validate(
            array_fill_keys($instance->getFillable(), 'required')
        );

        $instance->update($data);

        return redirect()->route('crud.index', $model);
    }

    public function destroy(string $model, $id)
    {
        $instance = $this->resolveModel($model)->findOrFail($id);
        $instance->delete();

        return redirect()->route('crud.index', $model);
    }
}
