<?php

namespace Database\Seeders;

use App\Models\Order;
use App\Models\Product;
use Illuminate\Database\Seeder;

class OrderProductSeeder extends Seeder
{
    public function run(): void
    {
        // Get all orders and products
        $orders = Order::all();
        $products = Product::all();

        if ($orders->isEmpty() || $products->isEmpty()) {
            $this->command->warn('No orders or products found. Create some first.');
            return;
        }

        foreach ($orders as $order) {
            // Attach 1-5 random products to each order
            $randomProducts = $products->random(rand(1, min(5, $products->count())));

            foreach ($randomProducts as $product) {
                $quantity = rand(1, 10);
                $pricePerUnit = $product->price ?? rand(10, 100);

                // Attach with pivot data
                $order->products()->attach($product->id, [
                    'quantity' => $quantity,
                    'price_per_unit' => $pricePerUnit,
                    'total_price' => $quantity * $pricePerUnit,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }

        $this->command->info('Order-Product relationships created successfully!');
    }
}
