import { ref } from 'vue'

function useTheme() {
    console.log('useTheme function called')

    // Load saved theme from localStorage, default to 'light'
    const savedTheme = localStorage.getItem('theme') || 'light'
    const theme = ref(savedTheme)

    const setTheme = (newTheme: string) => {
        console.log('setTheme function called with:', newTheme)
        theme.value = newTheme

        // Handle system theme
        if (newTheme === 'system') {
            const systemPrefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches
            if (systemPrefersDark) {
                document.documentElement.classList.add('dark')
            } else {
                document.documentElement.classList.remove('dark')
            }
        } else if (newTheme === 'dark') {
            document.documentElement.classList.add('dark')
        } else {
            document.documentElement.classList.remove('dark')
        }

        localStorage.setItem('theme', newTheme)
    }

    // Initialize theme on load
    const initTheme = () => {
        setTheme(theme.value)
    }

    // Initialize the theme when the composable is first used
    initTheme()

    return {
        theme,
        setTheme
    }
}

export default useTheme
