<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Invoice extends Model
{
    use HasFactory, HasUuids;

    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $table = 'invoices';

    protected $fillable = [
        'invoice_date',
        'status',
        'total_amount',
        'order_id'
    ];

    public static function getValidationRules($id = null): array
    {
        return [
            'invoice_date' => 'required|date|before_or_equal:today',
            'status' => 'required|string|in:draft,sent,paid,overdue,cancelled',
            'total_amount' => 'required|numeric|min:0|max:9999999.99',
            'order_id' => 'required|string|exists:orders,id|unique:invoices,order_id,' . $id,
        ];
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class, 'order_id');
    }
}
