<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Producer extends Model
{
    use HasFactory, HasUuids;
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'name',
        'address',
        'country',
        'phone_number',
        'email',
    ];

    public static function getValidationRules($id = null): array
    {
        return [
            'name' => 'required|string|max:255|unique:producers,name,' . $id,
            'address' => 'required|string|max:500',
            'country' => 'required|string|max:255',
            'phone_number' => 'nullable|string|max:255|regex:/^[\+]?[0-9\s\-\(\)]+$/',
            'email' => 'nullable|email|max:255|unique:producers,email,' . $id,
        ];
    }

    public function products(): HasMany
    {
        return $this->hasMany(Product::class, 'producer_id');
    }

    public function orders(): BelongsToMany
    {
        return $this->belongsToMany(Order::class, 'order_products')
            ->withPivot('quantity', 'price')
            ->withTimestamps();
    }
}
