<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Transport extends Model
{
    use HasFactory, HasUuids;
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';
    protected $fillable = [
        'name',
        'departure_point',
        'arrival_point',
        'estimated_departure_date',
        'estimated_arrival_date',
        'incoterm',
        'insurance_conditions',
    ];

    public static function getValidationRules($id = null): array
    {
        return [
            'name' => 'required|string|max:255',
            'departure_point' => 'required|string|max:255',
            'arrival_point' => 'required|string|max:255',
            'estimated_departure_date' => 'required|date|after_or_equal:today',
            'estimated_arrival_date' => 'required|date|after:estimated_departure_date',
            'incoterm' => 'required|string|in:EXW,FCA,CPT,CIP,DAP,DPU,DDP,FAS,FOB,CFR,CIF',
            'insurance_conditions' => 'nullable|string|max:1000',
        ];
    }
    public function order(): HasMany {
        return $this->hasMany(Order::class, 'transport_id');
    }
}
