<?php

namespace Database\Factories;

use App\Models\Client;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Client>
 */
class ClientFactory extends Factory
{
    protected $model = Client::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->company(),
            'country' => $this->faker->country(),
            'registration_number' => $this->faker->regexify('[A-Z]{2}[0-9]{8}'),
            'tax_code' => $this->faker->regexify('TAX[0-9]{10}'),
            'contact_person' => $this->faker->name(),
            'phone_number' => $this->faker->phoneNumber(),
            'billing_address' => $this->faker->address(),
            'shipping_address' => $this->faker->address(),
        ];
    }
}
