<?php

namespace Database\Factories;

use App\Models\Transport;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Transport>
 */
class TransportFactory extends Factory
{
    protected $model = Transport::class;

    public function definition(): array
    {
        $departureDate = $this->faker->dateTimeBetween('now', '+7 days');
        $arrivalDate = $this->faker->dateTimeBetween($departureDate, '+30 days');

        return [
            'name' => $this->faker->randomElement([
                'DHL Express', 'FedEx', 'UPS', 'Maersk', 'COSCO', 'MSC',
                'Emirates SkyCargo', 'Lufthansa Cargo', 'Air France KLM Cargo'
            ]),
            'departure_point' => $this->faker->city() . ', ' . $this->faker->country(),
            'arrival_point' => $this->faker->city() . ', ' . $this->faker->country(),
            'estimated_departure_date' => $departureDate,
            'estimated_arrival_date' => $arrivalDate,
            'incoterm' => $this->faker->randomElement([
                'EXW', 'FCA', 'CPT', 'CIP', 'DAP', 'DPU', 'DDP', 'FAS', 'FOB', 'CFR', 'CIF'
            ]),
            'insurance_conditions' => $this->faker->randomElement([
                'Full coverage', 'Partial coverage', 'Basic coverage', 'No coverage',
                'Marine insurance', 'Cargo insurance', 'Transit insurance'
            ]),
        ];
    }
}
