<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Packing List {{ $packingListNumber }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            color: #333;
            line-height: 1.5;
        }
        .header {
            margin-bottom: 30px;
            border-bottom: 3px solid #059669;
            padding-bottom: 20px;
        }
        .header h1 {
            font-size: 32px;
            color: #059669;
            margin-bottom: 5px;
        }
        .header .packing-details {
            text-align: right;
            font-size: 11px;
        }
        .company-info {
            margin-bottom: 10px;
        }
        .company-info h2 {
            font-size: 16px;
            margin-bottom: 5px;
        }
        .section {
            margin-bottom: 20px;
        }
        .section-title {
            font-size: 14px;
            font-weight: bold;
            color: #059669;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #e5e7eb;
        }
        .two-column {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        .column {
            display: table-cell;
            width: 48%;
            vertical-align: top;
        }
        .column:first-child {
            padding-right: 4%;
        }
        .info-box {
            background: #f0fdf4;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 10px;
            border: 1px solid #bbf7d0;
        }
        .info-box p {
            margin-bottom: 3px;
        }
        .info-box strong {
            display: inline-block;
            min-width: 100px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table thead {
            background: #059669;
            color: white;
        }
        table th {
            padding: 10px;
            text-align: left;
            font-weight: bold;
            font-size: 11px;
        }
        table td {
            padding: 8px 10px;
            border-bottom: 1px solid #e5e7eb;
        }
        table tbody tr:hover {
            background: #f0fdf4;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .summary-section {
            margin-top: 30px;
            background: #f0fdf4;
            padding: 20px;
            border-radius: 5px;
            border: 2px solid #059669;
        }
        .summary-grid {
            display: table;
            width: 100%;
        }
        .summary-item {
            display: table-cell;
            width: 25%;
            text-align: center;
            padding: 10px;
        }
        .summary-item .label {
            font-size: 11px;
            color: #6b7280;
            margin-bottom: 5px;
        }
        .summary-item .value {
            font-size: 20px;
            font-weight: bold;
            color: #059669;
        }
        .notes {
            margin-top: 30px;
            padding: 15px;
            background: #fef3c7;
            border-left: 4px solid #f59e0b;
            border-radius: 5px;
        }
        .notes strong {
            color: #92400e;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            font-size: 10px;
            color: #6b7280;
        }
        .weight-badge {
            display: inline-block;
            padding: 2px 8px;
            background: #dbeafe;
            color: #1e40af;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
        }
        .batch-details {
            font-size: 10px;
            color: #6b7280;
            margin-top: 2px;
        }
    </style>
</head>
<body>
<div class="header">
    <div style="display: table; width: 100%;">
        <div style="display: table-cell; width: 50%;">
            <div class="company-info">
                <h2>Your Company Name</h2>
                <p>123 Business Street</p>
                <p>Skopje, North Macedonia</p>
                <p>Email: info@company.com</p>
                <p>Phone: +389 XX XXX XXX</p>
            </div>
        </div>
        <div style="display: table-cell; width: 50%; text-align: right;">
            <h1>PACKING LIST</h1>
            <div class="packing-details">
                <p><strong>Packing List #:</strong> {{ $packingListNumber }}</p>
                <p><strong>Date:</strong> {{ $packingDate }}</p>
                <p><strong>Order ID:</strong> {{ $order->id }}</p>
                <p><strong>Order Date:</strong> {{ $order->date->format('Y-m-d') }}</p>
            </div>
        </div>
    </div>
</div>

<div class="two-column">
    <div class="column">
        <div class="section-title">Shipper (From)</div>
        <div class="info-box">
            <p><strong>{{ $order->buyer->name }}</strong></p>
            <p>{{ $order->buyer->address ?? 'N/A' }}</p>
            <p>{{ $order->buyer->city ?? '' }}, {{ $order->buyer->country ?? '' }}</p>
            <p>Contact: {{ $order->buyer->phone ?? 'N/A' }}</p>
            <p>Email: {{ $order->buyer->email ?? 'N/A' }}</p>
        </div>
    </div>
    <div class="column">
        <div class="section-title">Consignee (To)</div>
        <div class="info-box">
            <p><strong>{{ $order->receiver->name }}</strong></p>
            <p>{{ $order->receiver->address ?? 'N/A' }}</p>
            <p>{{ $order->receiver->city ?? '' }}, {{ $order->receiver->country ?? '' }}</p>
            <p>Contact: {{ $order->receiver->phone ?? 'N/A' }}</p>
            <p>Email: {{ $order->receiver->email ?? 'N/A' }}</p>
        </div>
    </div>
</div>

@if($order->transport)
    <div class="section">
        <div class="section-title">Transport Information</div>
        <div class="info-box">
            <p><strong>Transport Company:</strong> {{ $order->transport->name }}</p>
            @if(isset($order->transport->vehicle_type))
                <p><strong>Vehicle Type:</strong> {{ $order->transport->vehicle_type }}</p>
            @endif
            @if(isset($order->transport->driver))
                <p><strong>Driver:</strong> {{ $order->transport->driver }}</p>
            @endif
            @if(isset($order->transport->contact))
                <p><strong>Contact:</strong> {{ $order->transport->contact }}</p>
            @endif
        </div>
    </div>
@endif

<div class="section">
    <div class="section-title">Package Contents</div>
    <table>
        <thead>
        <tr>
            <th>Package #</th>
            <th>Batch Code</th>
            <th>Product Description</th>
            <th class="text-center">Quantity</th>
            <th class="text-right">Net Weight (kg)</th>
            <th class="text-right">Gross Weight (kg)</th>
        </tr>
        </thead>
        <tbody>
        @foreach($order->batches as $index => $batch)
            <tr>
                <td><strong>{{ $index + 1 }}</strong></td>
                <td>
                    <strong>{{ $batch->batch_code }}</strong>
                    <div class="batch-details">
                        Prod: {{ \Carbon\Carbon::parse($batch->production_date)->format('Y-m-d') }}
                        | Exp: {{ \Carbon\Carbon::parse($batch->expiration_date)->format('Y-m-d') }}
                    </div>
                </td>
                <td>
                    <strong>{{ $batch->product->name ?? 'N/A' }}</strong>
                    @if(isset($batch->product->description))
                        <div class="batch-details">{{ $batch->product->description }}</div>
                    @endif
                </td>
                <td class="text-center">
                    <span class="weight-badge">{{ $batch->pivot->quantity }} units</span>
                </td>
                <td class="text-right">{{ number_format($batch->net_weight, 2) }}</td>
                <td class="text-right">{{ number_format($batch->gross_weight, 2) }}</td>
            </tr>
        @endforeach
        </tbody>
        <tfoot>
        <tr style="background: #f0fdf4; font-weight: bold;">
            <td colspan="3" class="text-right"><strong>TOTALS:</strong></td>
            <td class="text-center">{{ $totalUnits }} units</td>
            <td class="text-right">{{ $totalNetWeight }} kg</td>
            <td class="text-right">{{ $totalGrossWeight }} kg</td>
        </tr>
        </tfoot>
    </table>
</div>

<div class="summary-section">
    <div class="summary-grid">
        <div class="summary-item">
            <div class="label">Total Packages</div>
            <div class="value">{{ $totalPackages }}</div>
        </div>
        <div class="summary-item">
            <div class="label">Total Units</div>
            <div class="value">{{ $totalUnits }}</div>
        </div>
        <div class="summary-item">
            <div class="label">Net Weight</div>
            <div class="value">{{ $totalNetWeight }} kg</div>
        </div>
        <div class="summary-item">
            <div class="label">Gross Weight</div>
            <div class="value">{{ $totalGrossWeight }} kg</div>
        </div>
    </div>
</div>

<div class="notes">
    <strong>⚠ Handling Instructions:</strong>
    <ul style="margin-left: 20px; margin-top: 10px;">
        <li>Handle with care - fragile contents</li>
        <li>Keep dry and store in cool place</li>
        <li>Do not stack more than 3 pallets high</li>
        <li>Check batch codes and expiration dates upon receipt</li>
        <li>Report any damage or discrepancies immediately</li>
    </ul>
</div>

<div style="margin-top: 50px; border-top: 1px solid #e5e7eb; padding-top: 20px;">
    <div style="display: table; width: 100%;">
        <div style="display: table-cell; width: 50%;">
            <p><strong>Prepared By:</strong></p>
            <p style="margin-top: 30px; border-top: 1px solid #333; width: 200px; padding-top: 5px;">Signature</p>
            <p>Date: {{ $packingDate }}</p>
        </div>
        <div style="display: table-cell; width: 50%;">
            <p><strong>Received By:</strong></p>
            <p style="margin-top: 30px; border-top: 1px solid #333; width: 200px; padding-top: 5px;">Signature</p>
            <p>Date: _______________</p>
        </div>
    </div>
</div>

<div class="footer">
    <p>This packing list is for reference purposes only and does not serve as a commercial invoice.</p>
    <p>For any discrepancies or questions, please contact us immediately at info@company.com</p>
</div>
</body>
</html>
