<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\GenericModelController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AuthController;
use Illuminate\Http\Request;

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'login'])->name('login');
    Route::post('/login', [AuthController::class, 'storeLogin'])->name('storeLogin');
});

Route::middleware('auth')->group(function () {
    Route::redirect('/', '/dashboard');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::prefix('users')->middleware('admin')->group(function () {
        Route::get('/', function (Request $request) {
            return app(GenericModelController::class)->index($request, 'users');
        })->name('generic.index');

        Route::post('/', function (Request $request) {
            return app(GenericModelController::class)->store($request, 'users');
        })->name('generic.store');

        Route::put('/{id}', function (Request $request, $id) {
            return app(GenericModelController::class)->update($request, 'users', $id);
        })->name('generic.update');

        Route::delete('/{id}', function (Request $request, $id) {
            return app(GenericModelController::class)->destroy('users', $id);
        })->name('generic.destroy');
    });

    Route::prefix('{model}')->where([
        'model' => '^(?!users$).*$'
    ])->group(function () {
        Route::get('/', [GenericModelController::class, 'index'])->name('generic.index');
        Route::post('/', [GenericModelController::class, 'store'])->name('generic.store');
        Route::put('/{id}', [GenericModelController::class, 'update'])->name('generic.update');
        Route::delete('/{id}', [GenericModelController::class, 'destroy'])->name('generic.destroy');
    });
});
