<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        User::create([
            'name' => env('INIT_USER_NAME', 'Default User'),
            'email' => env('INIT_USER_EMAIL', 'admin@pharmaexport.com'),
            'email_verified_at' => Carbon::now(),
            'password' => Hash::make(env('INIT_USER_PASS', 'password')),
            'is_admin' => true,
            'remember_token' => true,
        ]);

        User::create([
            'name' => 'Regular User',
            'email' => 'user@pharmaexport.com',
            'email_verified_at' => Carbon::now(),
            'password' => Hash::make('password'),
            'is_admin' => false,
            'remember_token' => 10,
        ]);

    }
}
