<?php

namespace Database\Factories;

use App\Models\Producer;
use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    protected $model = Product::class;
    public function definition(): array
    {
        $producer = Producer::first() ?? Producer::factory()->create();

        $pharmaceuticalProducts = [
            'Amoxicillin', 'Ibuprofen', 'Paracetamol', 'Omeprazole', 'Simvastatin',
            'Atorvastatin', 'Salbutamol', 'Metformin', 'Aspirin', 'Diazepam',
            'Fluoxetine', 'Morphine', 'Insulin', 'Levothyroxine', 'Prednisone'
        ];

        $units = ['vial', 'ampule', 'bottle', 'pack', 'scatula', 'carton'];

        return [
            'name' => $this->faker->unique()->randomElement($pharmaceuticalProducts) . ' ' . $this->faker->numerify('##mg'),
            'description' => $this->faker->paragraph(),
            'hs_code' => $this->faker->regexify('[0-9]{4}\.[0-9]{2}\.[0-9]{2}'),
            'price' => $this->faker->randomFloat(2, 10, 5000),
            'producer_id' => $producer->id,
            'unit_of_measure' => $this->faker->randomElement($units),
        ];
    }
}
