import { ref } from 'vue'

export default function useTheme() {
    console.log('useTheme function called')

    const theme = ref('light')

    const setTheme = (newTheme: string) => {
        console.log('setTheme function called with:', newTheme)
        theme.value = newTheme

        // Simple theme application
        if (newTheme === 'dark') {
            document.documentElement.classList.add('dark')
        } else {
            document.documentElement.classList.remove('dark')
        }

        localStorage.setItem('theme', newTheme)
    }

    return {
        theme,
        setTheme
    }
}
