<?php

namespace App\Http\Controllers;

use App\Models\Payment;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;

class DashboardController extends Controller
{
    public function index()
    {
        $currentRevenue = Payment::whereMonth('payment_date', now()->month)
            ->whereYear('payment_date', now()->year)
            ->where('payment_status', 'paid')
            ->sum('amount');

        $previousRevenue = Payment::whereMonth('payment_date', now()->subMonth()->month)
            ->whereYear('payment_date', now()->subMonth()->year)
            ->where('payment_status', 'paid')
            ->sum('amount');

        $monthlyRevenue = Payment::select(
            DB::raw("to_char(payment_date, 'YYYY-MM') as month"),
            DB::raw('SUM(amount) as revenue')
        )
            ->where('payment_status', 'paid')
            ->groupBy('month')
            ->orderBy('month')
            ->get()
            ->map(fn($row) => [
                'month' => $row->month,
                'revenue' => (float) $row->revenue, // ✅ Ensure numeric type for TS
            ]);

        return Inertia::render('Dashboard', [
            'currentRevenue' => (float) $currentRevenue,
            'previousRevenue' => (float) $previousRevenue,
            'monthlyRevenue' => $monthlyRevenue,
        ]);
    }
}
