<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Client extends Model
{
    use HasFactory, HasUuids;

    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'client_name',
        'country',
        'registration_number',
        'tax_id',
        'contact_person',
        'phone_number',
        'billing_address',
        'shipping_address',
    ];

    public static function getValidationRules($id = null): array
    {
        return [
            'client_name' => 'required|string|max:255',
            'country' => 'required|string|max:255',
            'registration_number' => 'nullable|string|max:255',
            'tax_id' => 'nullable|string|max:255',
            'contact_person' => 'nullable|string|max:255',
            'phone_number' => 'nullable|string|max:255',
            'billing_address' => 'nullable|string',
            'shipping_address' => 'nullable|string',
        ];
    }

    // Orders where this company is the buyer
    public function buyerOrders(): HasMany
    {
        return $this->hasMany(Order::class, 'buyer_id');
    }

    // Orders where this company is the receiver
    public function receiverOrders(): HasMany
    {
        return $this->hasMany(Order::class, 'receiver_id');
    }
}
