<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Route;

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'login'])->name('login');
    Route::post('/login', [AuthController::class, 'storeLogin'])->name('storeLogin');
});
Route::middleware('auth')->group(function () {
    Route::redirect('/', '/dashboard');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::prefix('{model}')->group(function () {
        Route::get('/', [GenericModelController::class, 'index'])->name('generic.index');
        Route::post('/', [GenericModelController::class, 'store'])->name('generic.store');
        Route::put('/{id}', [GenericModelController::class, 'update'])->name('generic.update');
        Route::delete('/{id}', [GenericModelController::class, 'destroy'])->name('generic.destroy');
    });
});
