<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Transport extends Model
{
    use HasFactory, HasUuids;
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';
    protected $fillable = [
        'carrier_name',
        'departure_point',
        'arrival_point',
        'estimated_departure_date',
        'estimated_arrival_date',
        'incoterm',
        'insurance_conditions',
    ];

    public function order(): HasMany {
        return $this->hasMany(Order::class, 'transport_id');
    }
}
