<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('order_id');
            $table->date('invoice_date');
            $table->string('status');
            $table->decimal('total_amount', 10, 2);
            $table->timestamps();

            // Foreign key constraint
//            $table->foreign('order_id')
//                ->references('id')
//                ->on('orders')
//                ->onDelete('cascade')
//                ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
