﻿namespace backend.Controllers;

using backend.DTOs;
using backend.Entities;
using backend.Helpers;
using backend.Models;
using backend.Services;
using Microsoft.AspNetCore.Mvc;
using System.Security.Claims;

[ApiController]
[Route("[controller]")]
public class ReservationsController : ControllerBase
{
    private readonly IReservationService _reservationService = null;

    public ReservationsController(IReservationService reservationService)
    {
        _reservationService = reservationService;
    }

    [HttpPost()]
    public async Task<IActionResult> CreateReservation([FromBody] CreateReservationRequest req)
    {
        await _reservationService.CreateReservation(req);
        return Ok();
    }

    [Authorize]
    [HttpPut("{rid}")]
    public async Task<IActionResult> ChangeStatus(int rid, [FromQuery] ReservationStatus status)
    {
        await _reservationService.ChangeReservationStatus(rid, status);
        return Ok();
    }
}
