﻿namespace backend.Controllers;

using backend.DTOs;
using backend.Entities;
using backend.Helpers;
using backend.Models;
using backend.Services;
using Microsoft.AspNetCore.Mvc;

[ApiController]
[Route("[controller]")]
public class UsersController : ControllerBase
{
    private readonly IUserService _userService = null;
    private readonly IRestaurantService _restaurantService = null;

    public UsersController(IUserService userService, IRestaurantService restaurantService)
    {
        _userService = userService;
        _restaurantService = restaurantService;
    }

    [HttpPost("login")]
    public async Task<AuthenticateResponse> Authenticate(AuthenticateRequest model)
    {
        var response = await _userService.Authenticate(model);

        if (response == null)
            throw new Exception("Email or password is incorrect");

        return response;
    }

    [HttpGet("authed")]
    public async Task<AuthenticateResponse> IsAuthed()
    {
        int userId = 0;
        try
        {
            userId = (int)this.HttpContext.Items["User"];
        }
        catch (Exception ex)
        {
            var usr = await _userService.GetByEmail((string)this.HttpContext.Items["User"]);
            if(usr == null)
            {
                return null;
            }
            userId = usr.Id;
        }
        User user = await _userService.GetById(userId);
        return new AuthenticateResponse() { Email=user.Email, Id = user.Id, IsAdmin = user.IsAdmin, IsConfirmed = user.IsConfirmed, isVip = user.IsVip};
    }

    [HttpPost("confirm")]
    public async Task ConfirmEmail()
    {
        int userId = 0;
        try
        {
            userId = (int)this.HttpContext.Items["User"];
        }
        catch (Exception ex) { return; }
        User user = await _userService.GetById(userId);
        await _userService.SendEmailConfirmation(user.Email);
    }

    [HttpPost("reset")]
    public async Task ResetPassword(string email)
    {
        await _userService.SendPasswordReset(email);
    }

    [HttpPost("confirmed")]
    public async Task ConfirmedEmail(string validityString)
    {
        int userId = 0;
        try
        {
            userId = (int)this.HttpContext.Items["User"];
        }
        catch (Exception ex) { return; }
        User user = await _userService.GetById(userId);
        await _userService.ConfirmEmail(user, validityString);
    }

    [HttpPost("reseted")]
    public async Task ResetedPassword(string validityString, string newPassword)
    {
        await _userService.ResetPassword(validityString, newPassword);
    }

    [HttpPost("register")]
    public async Task<AuthenticateResponse> Register(CreateUserRequest req)
    {
        bool isFirst = await _restaurantService.GetRestaurant() == null;
        var response = await _userService.Register(req, isFirst);
        if (isFirst)
        {
            await _restaurantService.CreateRestaurant("", response.Id);
        }
        return response;
    }

    [Authorize]
    [HttpGet()]
    public async Task<List<UserResponse>> GetUsers()
    {
        return await _userService.GetUsers();
    }

    [Authorize]
    [HttpPost("{id}/vip")]
    public async Task UpdateVip(int id, bool newStatus)
    {
        await _userService.UpdateVipStatus(id,newStatus);
    }
}
