﻿using backend.Data;
using backend.Entities;
using SendGrid;
using SendGrid.Helpers.Mail;

namespace backend.Email;
public interface IEmailSender
{
    Task SendEmailAsync(string subject, string body, string toEmail);
}
public class EmailSender : IEmailSender
{

    private readonly DataContext _context = null;
    public EmailSender(DataContext context)
    {
        _context = context;
    }

    public async Task SendEmailAsync(string subject, string message, string toEmail)
    {

        _context.QueueItems.Add(new QueueItem()
        {
            Subject = subject,
            Message = message,
            Reciptient = toEmail,
            CreatedAt = DateTime.UtcNow,
            Retries = 0
        });
        await _context.SaveChangesAsync();
    }
}