import React, {useState} from 'react'
import {useNavigate} from "react-router-dom";
import {Button, Card, Form, Input, Modal, notification} from "antd";
import { UserOutlined, LockOutlined } from '@ant-design/icons';
import axios from "axios";
import '../App.css'
import env from "../env";

const setAuthCookie = (token) => {
    localStorage.setItem('Auth','Bearer '+token)
}

const Login = ({setUser}) => {
    const history = useNavigate()

    const [loading, setLoading] = useState(false)

    const login = (attr) => {
        setLoading(true)
        axios.post(env.api+'Users/login',{email: attr.email, password: attr.password}).then(res => {
            setAuthCookie(res.data.token)
            console.log(res.data.token)
            setUser(res.data)
            setLoading(false)
            history(res.data.isAdmin ? '/dashboard' : '/')
        }).catch(el => {
            Modal.error({
                title: 'Погрешен мејл или лозинка',
            });
            setLoading(false)
        })
    }

    return(
        <div style={{width:'100vw',height:'100vh', textAlign:'center',backgroundColor:'#F2F2F2'}}>
            <div className='center'>
                <Card style={{backgroundColor:'white', width:'100%', borderRadius:'20px'}} className='center'>
                    <h1>Најави се</h1>
                    <Form
                        name="normal_login"
                        onFinish={res=>login(res)}
                    >
                        <Form.Item
                            name="email"
                            rules={[
                                {
                                    required: true,
                                    message: 'Внесете мејл',
                                },
                                {
                                    type: 'email',
                                    message: 'Внесете валиден мејл',
                                },
                            ]}
                        >
                            <Input prefix={<UserOutlined className="site-form-item-icon" />} placeholder="Email" />
                        </Form.Item>
                        <Form.Item
                            name="password"
                            rules={[
                                {
                                    required: true,
                                    message: 'Внесете лозинка!',
                                }
                            ]}
                        >
                            <Input
                                prefix={<LockOutlined className="site-form-item-icon" />}
                                type="password"
                                placeholder="Password"
                            />
                        </Form.Item>

                        <Form.Item style={{margin:'0px'}}>
                            <Button type="primary" htmlType="submit" className="login-form-button" loading={loading}>
                                Log in
                            </Button>
                            <div>
                                Или <a href={"/register"}>регистрирај се!</a>
                            </div>
                            <div>
                                <a href={"/reset-password"}>Заборави лозинка?</a>
                            </div>
                        </Form.Item>
                    </Form>
                </Card>
            </div>
        </div>
    )
}

const Register = ({setUser}) => {

    const [loading, setLoading] = useState(false)
    const history = useNavigate()
    const register = (attr) => {
        if (attr.password !== attr.confirm) {
            Modal.error({
                title: 'Лозинките не се исти',
            });
            return;
        }
        setLoading(true)
        axios.post(env.api+'Users/register',{email: attr.email, password: attr.password}).then(res => {
            setAuthCookie(res.data.token)
            setUser(res.data)
            setLoading(false)
            history('/confirm-email')
        })
    }
    return(
        <div style={{width:'100vw',height:'100vh', textAlign:'center', backgroundColor:'#F2F2F2'}}>
            <div className='center'>
                <Card style={{backgroundColor:'white', width:'100%', borderRadius:'20px'}} className='center'>
                    <h1>Регистрирај се</h1>
                    <Form
                        name="normal_login"
                        onFinish={(attr)=>register(attr)}
                    >
                        <Form.Item
                            name="email"
                            rules={[
                                {
                                    required: true,
                                    message: 'Внесете мејл',
                                },
                                {
                                    type: 'email',
                                    message: 'Внесете валиден мејл',
                                },
                            ]}
                        >
                            <Input prefix={<UserOutlined className="site-form-item-icon" />} placeholder="Email" />
                        </Form.Item>
                        <Form.Item
                            name="password"
                            rules={[
                                {
                                    required: true,
                                    message: 'Внесете лозинка!',
                                },
                            ]}
                        >
                            <Input
                                prefix={<LockOutlined className="site-form-item-icon" />}
                                type="password"
                                placeholder="Password"
                            />
                        </Form.Item>
                        <Form.Item
                            name="confirm"
                            rules={[
                                {
                                    required: true,
                                    message: 'Потврдете лозинка!',
                                },
                            ]}
                        >
                            <Input
                                prefix={<LockOutlined className="site-form-item-icon" />}
                                type="password"
                                placeholder="Confirm password"
                            />
                        </Form.Item>

                        <Form.Item style={{margin:'0px'}}>
                            <Button type="primary" htmlType="submit" className="login-form-button" loading={loading}>
                                Register
                            </Button>
                            <div>
                                Или <a href={"/login"}>најави се!</a>
                            </div>
                        </Form.Item>
                    </Form>
                </Card>
            </div>
        </div>
    )
}

export {Login,Register};