﻿using backend.DTOs;
using backend.Helpers;
using backend.Services;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace backend.Controllers
{
    [ApiController]
    [Route("[controller]")]
    public class ReviewsController : ControllerBase
    {
        private readonly IReviewService _reviewService = null;

        public ReviewsController(IReviewService reviewService)
        {
            _reviewService = reviewService;
        }

        [HttpGet]
        public async Task<List<ReviewResponse>> GetReviews(int page, int pageSize)
        {
            return await _reviewService.GetReviews(page, pageSize);
        }

        [HttpGet("count")]
        public async Task<int> GetReviewsCount()
        {
            return await _reviewService.GetCount();
        }

        [Authorize]
        [HttpPost()]
        public async Task<IActionResult> CreateReview([FromBody] CreateReviewRequest req)
        {
            int userId = 0;
            try
            {
                userId = (int)this.HttpContext.Items["User"];
            }
            catch (Exception ex) { return null; }
            await _reviewService.AddReview(req, userId);
            return Ok();
        }

    }

}
