﻿using backend.Data;
using backend.DTOs;
using backend.Entities;
using Microsoft.EntityFrameworkCore;

namespace backend.Services
{
    public interface IReservationService
    {
        public Task CreateReservation(CreateReservationRequest req);
        public Task ChangeReservationStatus(int resId, ReservationStatus status);
    }
    public class ReservationService : IReservationService
    {
        private readonly DataContext _context = null;
        private readonly ISmsService _smsService = null;

        public ReservationService(DataContext context, ISmsService smsService)
        {
            _context = context;
            _smsService = smsService;
        }

        public async Task ChangeReservationStatus(int resId, ReservationStatus status)
        {
            var reservation = await _context.Reservations.FindAsync(resId);
            reservation.ReservationStatus = status;
            _context.Update(reservation);
            await _context.SaveChangesAsync();
            _smsService.ReservationStatusUpdate(reservation.ContactName, reservation.ContactNumber, reservation.ReservationStatus);
        }

        public async Task CreateReservation(CreateReservationRequest req)
        {
            Restaurant res = await _context.Restoraunts.Include(x => x.Reservations).FirstOrDefaultAsync();
            Reservation reservation = new Reservation()
            {
                ContactName = req.ContactName,
                ContactNumber = req.ContactNumber,
                ReservationPlace = req.ReservationPlace,
                ReservationType = req.ReservationType,
                StartDate = req.StartDate,
                Persons = req.Persons,
                ReservationStatus = ReservationStatus.New
            };
            res.Reservations.Add(reservation);
            _context.Restoraunts.Update(res);
            await _context.SaveChangesAsync();
        }
    }
}
