﻿using backend.Entities;

namespace backend.Services
{
    public interface ISmsService
    {
        public Task ReservationStatusUpdate(string name, string number, ReservationStatus newStatus);
    }
    public class SmsService : ISmsService
    {
        public async Task ReservationStatusUpdate(string name, string number, ReservationStatus newStatus)
        {
            string message = $"Hello {name}, the status of your reservation was changed to: { Enum.GetName(typeof(ReservationStatus), newStatus)}";

            // simulate sending sms
            await Task.Delay(100);
            Console.WriteLine(message);
        }
    }
}
