﻿namespace backend.Controllers;

using backend.DTOs;
using backend.Entities;
using backend.Helpers;
using backend.Models;
using backend.Services;
using Microsoft.AspNetCore.Mvc;

[ApiController]
[Route("[controller]")]
public class UsersController : ControllerBase
{
    private readonly IUserService _userService = null;
    private readonly IRestaurantService _restaurantService = null;

    public UsersController(IUserService userService, IRestaurantService restaurantService)
    {
        _userService = userService;
        _restaurantService = restaurantService;
    }

    [HttpPost("login")]
    public async Task<AuthenticateResponse> Authenticate(AuthenticateRequest model)
    {
        var response = await _userService.Authenticate(model);

        if (response == null)
            throw new Exception("Email or password is incorrect");

        return response;
    }

    [HttpGet("authed")]
    public async Task<AuthenticateResponse> IsAuthed()
    {
        int userId = 0;
        try
        {
            userId = (int)this.HttpContext.Items["User"];
        }catch (Exception ex){ return null; }
        User user = await _userService.GetById(userId);
        return new AuthenticateResponse() { Email=user.Email, Id = user.Id};
    }

    [HttpPost("register")]
    public async Task<AuthenticateResponse> Register(CreateUserRequest req)
    {
        bool isFirst = await _restaurantService.GetRestaurant() == null;
        var response = await _userService.Register(req, isFirst);
        if (isFirst)
        {
            await _restaurantService.CreateRestaurant("", response.Id);
        }
        return response;
    }
}
