﻿using backend.Entities;
using Microsoft.EntityFrameworkCore;

namespace backend.Data
{
    public class DataContext : DbContext
    {
        public DataContext(DbContextOptions<DataContext> dbContextOptions) : base(dbContextOptions)
        {
        }

        private DbSet<User> users;
        public DbSet<User> Users
        {
            get
            {
                if (users == null)
                {
                    users = Set<User>();
                }

                return users;
            }
        }

        private DbSet<Restaurant> restaurants;
        public DbSet<Restaurant> Restoraunts
        {
            get
            {
                if (restaurants == null)
                {
                    restaurants = Set<Restaurant>();
                }

                return restaurants;
            }
        }

        private DbSet<Reservation> reservations;
        public DbSet<Reservation> Reservations
        {
            get
            { 
                if (reservations == null)
                {
                    reservations = Set<Reservation>();
                }

                return reservations;
            }
        }

        private DbSet<MenuItem> menuItems;
        public DbSet<MenuItem> MenuItems
        {
            get
            {
                if (menuItems == null)
                {
                    menuItems = Set<MenuItem>();
                }

                return menuItems;
            }
        }

        private DbSet<Review> reviews;
        public DbSet<Review> Reviews
        {
            get
            {
                if (reviews == null)
                {
                    reviews = Set<Review>();
                }

                return reviews;
            }
        }


        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //
            // User
            // 
            modelBuilder.Entity<User>().Property(x => x.Id).IsRequired().ValueGeneratedOnAdd();
            modelBuilder.Entity<User>()
            .HasOne(p => p.Restaurant)
            .WithOne(b => b.Owner);

            //
            // Restoraunt
            // 
            modelBuilder.Entity<Restaurant>().Property(x => x.Id).IsRequired().ValueGeneratedOnAdd();
            modelBuilder.Entity<Restaurant>()
            .HasOne(p => p.Owner)
            .WithOne(b => b.Restaurant)
            .HasForeignKey<Restaurant>(k => k.OwnerFk);
            modelBuilder.Entity<Restaurant>()
            .HasMany(p => p.Reservations)
            .WithOne(b => b.Restaurant);
            modelBuilder.Entity<Restaurant>()
            .HasMany(p => p.Reviews)
            .WithOne(b => b.Restaurant);

            //
            // Reservation
            // 
            modelBuilder.Entity<Reservation>().Property(x => x.Id).IsRequired().ValueGeneratedOnAdd();
            modelBuilder.Entity<Reservation>()
            .HasOne(p => p.Restaurant)
            .WithMany(b => b.Reservations);

            //
            // MenuItem
            // 
            modelBuilder.Entity<MenuItem>().Property(x => x.Id).IsRequired().ValueGeneratedOnAdd();
            modelBuilder.Entity<MenuItem>()
            .HasOne(p => p.Restaurant)
            .WithMany(b => b.Menu);

            //
            // Review
            // 
            modelBuilder.Entity<Review>().Property(x => x.Id).IsRequired().ValueGeneratedOnAdd();
            modelBuilder.Entity<Review>()
            .HasOne(p => p.Restaurant)
            .WithMany(b => b.Reviews);
            modelBuilder.Entity<Review>()
            .HasOne(p => p.User);
        }
    }
}
