import './App.css';
import {Route, BrowserRouter as Router, Navigate, Routes, useNavigate} from "react-router-dom";
import axios from 'axios'
import env from './env'

import {Spin} from "antd";
import React, {useEffect, useState} from "react";
import {Login, Register} from "./auth";
import Dashboard from "./Dashboard";
import Reservations from "./Dashboard/Reservations";
import FrontPage from "./FrontPage";
import Restaurant from "./Dashboard/Restaurant";
import Menu from "./Dashboard/Menu";
import Review from "./Dashboard/Review";


function App() {
  const [user, setUser] = useState(undefined)
  const [loading, setLoading] = useState(false)
  useEffect(()=>{
    getUser()
  },[])

  const getUser = () => {
    setLoading(true)
    axios.get(env.api+'Users/authed',{headers:{Authorization:sessionStorage.getItem('Auth')}}).then(res=>{
      console.log(!res.data)
      setUser(res.data)
      setLoading(false)
    })
  }
  const logout = () => {
    setUser(undefined);
    sessionStorage.removeItem('Auth');
    window.location.replace('/')
  }
  return (
    <div style={{textAlign:'center'}}>
      <Router>
          <Routes>
            <Route path="/dashboard" element={loading ? <Spin /> : user ? (user.isAdmin ? <Dashboard setUser={setUser}/> : <Navigate to="/" replace={true} />) :  <Navigate to="/login" replace={true} />}>
              <Route path="/dashboard" element={<Restaurant/>}/>
              <Route path="/dashboard/menu" element={<Menu/>}/>
              <Route path="/dashboard/reservations" element={<Reservations/>}/>
              <Route path="/dashboard/reviews" element={<Review/>}/>
              <Route path="/dashboard/todo" element={'todo'}/>
            </Route>
            <Route path="/login" element={loading ? <Spin /> :  !user ? <Login setUser={setUser}/> :  <Navigate to="/dashboard" replace={true} />}/>
            <Route path="/register" element={loading ? <Spin /> :  !user ? <Register setUser={setUser}/> :  <Navigate to="/dashboard" replace={true} />}/>
            <Route path="/" element={<FrontPage user={user} logout={logout}/>}/>
          </Routes>
      </Router>
    </div>
  );
}

export default App;
