import React, {useEffect, useState} from 'react'
import {Button, Card, Input, List, Rate, Spin, Tooltip} from "antd";
import axios from "axios";
import env from "../env";
import moment from "moment";

const Review = props => {
    const [restaurant, setRestaurant] = useState({});
    const [loading, setLoading] = useState(true);

    useEffect(()=> {
        setLoading(true);
        getRestaurant()
    },[])
    useEffect(()=> {
        getRestaurant()
    },[props.refresh])

    const getRestaurant = () => {
        axios.get(env.api + 'Restaurants').then(res=>{
            setRestaurant(res.data);
            setLoading(false);
        });
    }

    return(
        <div style={{padding: props.front ? 0 : '20px',textAlign:'start'}}>
            <div style={{
                width: '100%',
                backgroundColor: 'white',
                padding: '20px',
                height:'75px',
                border: '1px solid lightgray'
            }} id={'expandMain'}>
                <h2 style={{float: 'left'}}>Оценки</h2>
                {props.front ?
                    (props.user?
                        <Button style={{float:'right'}} type={'primary'} onClick={()=>props.setVisible(true)}>Внеси оценка</Button>
                        : <Tooltip title={'Мора да се најавите за да оставите оценка'}><Button style={{float:'right'}} disabled type={'primary'} onClick={()=>props.setVisible(true)}>Внеси оценка</Button></Tooltip>)
                    : ''
                }
            </div>
            {loading ? <Spin style={{margin: '20px'}}/> :
                <div>
                    <div style={{backgroundColor: 'white',padding:'10px', border:'1px solid lightgray', borderTop: 'none'}}>
                        <h3>Средна оценка: <Rate disabled allowHalf value={restaurant.averageReview}/> од вкупно {restaurant.reviews.length} оценки</h3>
                    </div>
                    <List dataSource={restaurant.reviews} itemLayout={'horizontal'} locale={{emptyText:'Нема оставени оценки за овој ресторан'}}
                          renderItem={item => (
                              <Card title={item.title} style={{width:'98%',backgroundColor:'white',margin:'1%'}}>
                                  <p>{item.description}</p>
                                  <Rate disabled value={item.stars}/>
                                  <p style={{color:'gray'}}>{item.username} / {moment(item.createdAt).format("DD.MM.yyyy")}</p>
                              </Card>
                          )}/>
                </div>

            }
        </div>
    )
}

export default Review;