﻿namespace backend.Controllers;

using backend.DTOs;
using backend.Entities;
using backend.Helpers;
using backend.Models;
using backend.Services;
using Microsoft.AspNetCore.Mvc;
using System.Security.Claims;

[ApiController]
[Route("[controller]")]
public class RestaurantsController : ControllerBase
{
    private readonly IRestaurantService _restaurantService = null;

    public RestaurantsController(IRestaurantService restaurantService)
    {
        _restaurantService = restaurantService;
    }

    /*
    [Authorize]
    [HttpPost()]
    public async Task<IActionResult> CreateRestaurant([FromQuery] string title)
    {
        var userId = (int) this.HttpContext.Items["User"];
        await _restaurantService.CreateRestaurant(title, userId);


        return Ok();
    }
    */

    [HttpGet()]
    public async Task<RestaurantResponse> GetRestaurant()
    {
        var response = await _restaurantService.GetRestaurant();
        return response;
    }

    [HttpPost("upload")]
    public async Task<IActionResult> UploadImage([FromForm] IFormFile file)
    {
        await _restaurantService.UploadImage(file);
        return Ok();
    }

    [Authorize]
    [HttpPut()]
    public async Task<IActionResult> UpdateRestaurant([FromBody] UpdateRestaurantRequest req)
    {
        await _restaurantService.UpdateRestaurant(req);
        return Ok();
    }
}
