﻿using backend.Data;
using backend.DTOs;
using backend.Entities;
using Microsoft.EntityFrameworkCore;

namespace backend.Services
{
    public interface IReviewService
    {
        public Task AddReview(CreateReviewRequest review, int userId);
    }
    public class ReviewService : IReviewService
    {
        private readonly DataContext _context = null;

        public ReviewService(DataContext context)
        {
            _context = context;
        }

        public async Task AddReview(CreateReviewRequest review, int userId)
        {
            var user = await _context.Users.FindAsync(userId);
            var res = await _context.Restoraunts.Include(x => x.Reviews).FirstOrDefaultAsync();
            if(res.Reviews == null)
            {
                res.Reviews = new List<Review>();
            }
            res.Reviews.Add(new Review()
            {
                Title = review.Title,
                Description = review.Description,
                Stars = review.Stars,
                CreatedAt = DateTime.UtcNow,
                User = user
            });
            _context.Restoraunts.Update(res);
            await _context.SaveChangesAsync();
        }
    }
}
