import React, {useEffect, useState} from 'react';
import {Header} from "../Header";
import {Button, Form, Input, Modal, notification, Spin} from "antd";
import axios from "axios";
import '../App.css'
import env from "../env";
import {useNavigate, useSearchParams} from "react-router-dom";

const Reset = () => {

    const [loading, setLoading] = useState(false);
    const [searchParams, setSearchParams] = useSearchParams();

    const history = useNavigate()
    const resetPassword = (data) => {
        setLoading(true)
        const param = searchParams.get("id");
        if(param==null){
            Modal.error({
                title: 'Невалиден линк',
            });
            return;
        }
        axios.post(env.api+"Users/reseted",{}, {
            params: {
                validityString: param,
                newPassword: data.password
            }}).then(el => {
            setLoading(false)
            Modal.success({
                title: 'Успешно потврдена сменета лозинка. Ќе бидете редиректирани за 3 секунди',
            });
            setTimeout(()=>{
                history('/login')
            },3000)
        }).catch(er=>{
            setLoading(false)
            if(er.response.data.includes("Invalid check")){
                Modal.error({
                    title: 'Невалиден линк',
                });
            }
            if(er.response.data.includes("Link expired")){
                Modal.error({
                    title: 'Линкот е стар. Ве молиме обновете го.',
                });
            }
        });
    }

    return (
        <div>
            <div style={{width:'100vw',height:'100vh', textAlign:'center',backgroundColor:'#F2F2F2'}}>
                <div className='center' style={{backgroundColor:'white',padding:'40px', borderRadius:'20px'}}>
                    <h1 style={{marginBottom:'40px'}}>Ресетирајте ја вашата лозинка</h1>
                    <Form onFinish={resetPassword}
                          onFinishFailed={() => Modal.error({title: "Ве молиме пополнете ги задолжителните полиња"})}>
                        <Form.Item
                            label="Нова лозинка"
                            name="password"
                            rules={[
                                {
                                    required: true,
                                    message: 'Ве молиме внесете ја новата лозинка!',
                                },
                            ]}
                        >
                            <Input type={'password'}/>
                        </Form.Item>
                        <Form.Item>
                            <Button type="primary" htmlType="submit" loading={loading}>
                                Прати
                            </Button>
                        </Form.Item>
                    </Form>
                </div>
            </div>
        </div>
    )
}

export default Reset;