import React, {useEffect} from 'react';
import {Header} from "../Header";
import {Button, Spin} from "antd";
import axios from "axios";
import env from "../env";

const SendConfirm = ({setUser, user}) => {
    const logout = () => {
        localStorage.removeItem('Auth');
        setUser(false)
    }

    const sendConfirmationEmail = () => {
        axios.post(env.api + "Users/confirm", {}, {headers: {Authorization: localStorage.getItem('Auth')}}).then(el => {
            console.log("sent")
        }).catch(er => {
            console.log(er);
        });
    }
    useEffect(()=>{
        console.log("once")
        if(user && !user.isConfirmed) {
            sendConfirmationEmail()
        }
    },[])

    return (
        <div>
            <Header onClickButton={() => logout()} buttonText={'Одјави се'}/>
            {!user.isConfirmed ?
                <div style={{textAlign:'center',margin:'50px'}}>
                    <h2>За да го користите овој вебсајт потребно е да го потврдите вашиот профил. Мејл за потврда на вашиот профил е пратен на вашата емаил адреса.</h2>
                    <Button type='primary' onClick={sendConfirmationEmail}>
                        Прати повторно
                    </Button>
                </div>
                :
                <div style={{textAlign:'center',margin:'50px'}}>
                    <h2>Вашиот емаил е веќе потврден.</h2>
                </div>
            }
        </div>
    )
}

export default SendConfirm;