import React, {useEffect, useState} from 'react';
import {Header} from "../Header";
import {Button, Form, Input, Modal, notification, Spin} from "antd";
import axios from "axios";
import '../App.css'
import env from "../env";

const SendReset = () => {

    const [loading, setLoading] = useState(false);

    const sendResetEmail = (data) => {
        setLoading(true)
        axios.post(env.api + "Users/reset?email="+data.email, {}).then(el => {
            setLoading(false);
            Modal.success({
                title: 'Инструкции за ресетирање на вашата лозинка се испратени на вашиот мејл',
            });
        }).catch(er => {
            setLoading(false);
            Modal.error({
                title: 'Се случи проблем',
            });
            console.log(er);
        });
    }

    return (
        <div>
            <div style={{width:'100vw',height:'100vh', textAlign:'center',backgroundColor:'#F2F2F2'}}>
                <div className='center' style={{backgroundColor:'white',padding:'40px', borderRadius:'20px'}}>
                    <h1 style={{marginBottom:'40px'}}>Ресетирајте ја вашата лозинка</h1>
                    <Form onFinish={sendResetEmail}
                          onFinishFailed={() => Modal.error({title: "Ве молиме пополнете ги задолжителните полиња"})}>
                        <Form.Item
                            label="Емаил"
                            name="email"
                            rules={[
                                {
                                    required: true,
                                    message: 'Ве молиме внесете емаил!',
                                },
                            ]}
                        >
                            <Input/>
                        </Form.Item>
                        <Form.Item>
                            <Button type="primary" htmlType="submit" loading={loading}>
                                Прати
                            </Button>
                        </Form.Item>
                    </Form>
                </div>
            </div>
        </div>
    )
}

export default SendReset;