import React, {useState, useEffect} from 'react'
import {Header} from "./Header";
import {Link, useNavigate} from "react-router-dom";
import {Button, Card, DatePicker, Form, Image, Input, Modal, notification, Rate, Spin} from "antd";
import placeholderImage from '../src/Assets/placeholder.png'
import AddNewReservation from "./Dashboard/AddNewReservation";
import axios from "axios";
import env from "./env";
import Review from "./Dashboard/Review";

const FrontPage = ({user, logout}) => {
    const [restaurant, setRestaurant] = useState({name:'Sample Restaurant name', address: 'Sample street 1', city:'Sample'});
    const [newReservationModal, setNewReservationModal] = useState(false);
    const [saveModalLoading, setSaveModalLoading] = useState(false);
    const [newReviewModal, setNewReviewModal] = useState(false);
    const [loading, setLoading] = useState(true);
    const [refreshToggle, setRefreshToggle] = useState(false);
    const history = useNavigate();

    useEffect(()=>{
        setLoading(true);
        axios.get(env.api + 'Restaurants').then(res=>{
            setRestaurant(res.data);
            setLoading(false);
        });
    },[])

    useEffect(()=>{
        if(user && !user.isConfirmed) {
            notification['warning']({
                message: <p>Вашиот емаил не е потврден. <a href={'/confirm-email'}>Потврдете го тука</a></p>
            });
        }
    },[user])

    const saveNewReview = data =>{
        setSaveModalLoading(true)
        axios.post(env.api + 'Reviews',data,{ headers: {Authorization: localStorage.getItem('Auth')}}).then(res=>{
            setNewReviewModal(false)
            setSaveModalLoading(false)
            notification['success']({
                message: 'Успешно зачувано',
            });
            setRefreshToggle(ref => !ref);
        }).catch(err=>{
            setSaveModalLoading(false)
            notification['error']({
                message: 'Се случи проблем при зачувување',
            });
        });
    }

    return(
        <div>
            <Header onClickButton={!user?()=>history('/login'):logout} buttonText={!user?'Најави се':'Одјави се'}/>
            {loading ? <Spin style={{margin: 20}}/> :
                <div style={{
                    height: '400px',
                    width: '100%',
                    borderTop: '1px solid gray',
                    padding: '20px'
                }}>
                    <div id={'businessFrontImage'}>
                        <Image
                            src={restaurant.base64Image}
                            id={'businessFrontInsideImage'}
                            placeholder={
                                <img
                                    src={placeholderImage}
                                    alt={'place'}
                                    style={{width: '100%', height: '100%'}}
                                />
                            }
                            wrapperStyle={{overflow: 'hidden', width: '100%'}}
                            style={{width: '100%', height: '100%', margin: 'auto', objectFit: 'cover'}}>
                        </Image>
                    </div>
                    <div id={'businessFrontInfo'}>
                        <div style={{
                            width: '100%',
                            height: '100%',
                            display: 'flex',
                            flexDirection: 'column',
                            justifyContent: 'space-between'
                        }}>
                            <div style={{flexGrow: 1, fontSize: '20px', fontWeight: '500', textAlign: 'start'}}>
                                {restaurant.name}
                                <div style={{
                                    color: 'gray',
                                    fontSize: '10px'
                                }}>{restaurant.address}, {restaurant.phone}</div>
                            </div>
                            <Button onClick={() => setNewReservationModal(true)}
                                    style={{width: '100%', marginTop: '5px'}} type={'primary'}>Резервирај</Button>
                        </div>

                    </div>
                    <div style={{textAlign: 'start', backgroundColor: '#F2F2F2'}}>
                        <div style={{
                            width: '100%',
                            height:'75px',
                            backgroundColor: 'white',
                            padding: '20px',
                            border: '1px solid lightgray'
                        }} >
                            <h2 style={{float: 'left'}}>Мени</h2>
                        </div>
                        {restaurant.menu.map(el =>
                            <Card key={el.id} title={el.title} style={{ width: 280, display:'inline-block', margin:'10px' }} size="small">
                                <p>{el.description}</p>
                                <b>{el.price} ден.</b>
                            </Card>
                        )}
                        <Review user={user} front refresh={refreshToggle} setVisible={setNewReviewModal}/>
                    </div>
                </div>
            }
            <Modal
                style={{top: 20}}
                width={'700px'}
                title="Нова Резервација"
                footer={[
                    <Button form="newResForm" key="submit" htmlType="submit" type={'primary'} loading={saveModalLoading}>
                        Прати
                    </Button>
                ]}
                onCancel={()=>setNewReservationModal(false)}
                visible={newReservationModal}>
                <AddNewReservation setModalSaveLoading={setSaveModalLoading} setModalVisible={setNewReservationModal} />
            </Modal>
            <Modal
                style={{top: 20}}
                width={'700px'}
                title="Нова оценка"
                footer={[
                    <Button form="newReviewForm" key="submit" htmlType="submit" type={'primary'} loading={saveModalLoading}>
                        Прати
                    </Button>
                ]}
                onCancel={()=>setNewReviewModal(false)}
                visible={newReviewModal}>
                <Form onFinish={saveNewReview}
                      id={'newReviewForm'}
                      onFinishFailed={()=>
                          notification['error']({
                              message: 'Ве молиме поправете ги сите грешки пред зачувување!',
                          })}>
                    <Form.Item
                        label="Наслов"
                        name="title"
                        rules={[
                            {
                                required: true,
                                message: 'Ве молиме внесете наслов!',
                            },
                        ]}
                    >
                        <Input/>
                    </Form.Item>
                    <Form.Item
                        label="Опис"
                        name="description"
                        rules={[
                            {
                                required: true,
                                message: 'Ве молиме внесете опис!',
                            },
                        ]}
                    >
                        <Input.TextArea rows={4}/>
                    </Form.Item>
                    <Form.Item
                        label="Оценка"
                        name="stars"
                        rules={[
                            {
                                required: true,
                                message: 'Ве молиме внесете оценка!',
                            },
                        ]}
                    >
                        <Rate/>
                    </Form.Item>
                </Form>
            </Modal>
        </div>
    )
}
export default FrontPage;