import React, {useEffect, useState} from 'react'
import {Header} from "../Header";
import {Modal, notification, Spin} from "antd";
import {useLocation} from "react-router";
import {useNavigate, useSearchParams} from "react-router-dom";
import axios from "axios";
import env from "../env";

const Confirm = ({setUser, user}) => {

    const history = useNavigate()
    const [result, setResult] = useState("")
    const [searchParams, setSearchParams] = useSearchParams();

    useEffect(()=>{
        const param = searchParams.get("id");
        if(param==null){
            setResult("Invalid key");
            return;
        }
        axios.post(env.api+"Users/confirmed?validityString="+param,{},{headers:{Authorization:localStorage.getItem('Auth')}}).then(el => {
            setResult("Успешно потврдена емаил адреса. Ќе бидете редиректирани за 3 секунди")
            setUser(user => {return {...user,isConfirmed: true}})
            setTimeout(()=>{
                history('/login')
            },3000)
        }).catch(er=>{
            if(er.response.data.includes("Invalid check")){
                setResult("Невалиден линк")
            }
            if(er.response.data.includes("Link expired")){
                setResult("Линкот е стар. Ве молиме обновете го.")
            }
        });

    },[])

    return (
        <div>
            <Header/>
            <div style={{textAlign:'center',margin:'50px'}}>
                {result == "" ? <Spin/> : <h2>{result}</h2>}
            </div>
        </div>
    )
}
export default Confirm;