import React, {useEffect, useState} from 'react'
import {Button, Form, Input, Card, notification} from "antd";
import axios from "axios";
import env from "../env";

const Menu = props => {

    const [loadingSave, setLoadingSave] = useState(false);
    const [restaurant, setRestaurant] = useState({menu:[]});
    const [loading, setLoading] = useState(true);

    useEffect(()=> {
        setLoading(true);
        getRestaurant()
    },[])

    const getRestaurant = () => {
        axios.get(env.api + 'Restaurants').then(res=>{
            setRestaurant(res.data);
            setLoadingSave(false);
            setLoadingSave(false);
        });
    }

    const addMenu = (data) => {
        setLoadingSave(true);
        axios.post(env.api + 'Menu/',{...data,price: parseInt(data.price)}, { headers: {Authorization: localStorage.getItem('Auth')}
        }).then(res => {
            notification['success']({
                message: 'Успешно зачувано',
            });
            getRestaurant()
        }).catch(er => {
            notification['error']({
                message: 'Се случи проблем при зачувување мени. Ве молиме пробајте повторно подоцна',
            });
            setLoadingSave(false);
            console.log(er);
        })
        console.log(data)
    }

    const deleteMenu = (id) => {
        axios.delete(env.api + 'Menu/'+id, {headers: {Authorization: localStorage.getItem('Auth')}
        }).then(res => {
            notification['success']({
                message: 'Успешно избришано',
            });
            getRestaurant()
        }).catch(er => {
            notification['error']({
                message: 'Се случи проблем при бришење мени. Ве молиме пробајте повторно подоцна',
            });
            console.log(er);
        })
    }

    return(
        <div style={{padding:'20px'}}>
            <div style={{backgroundColor:'white'}}>
                <div style={{
                    width: '100%',
                    height:'75px',
                    backgroundColor: 'white',
                    padding: '20px',
                    border: '1px solid lightgray'
                }} >
                    <h2 style={{float: 'left'}}>Мени</h2>
                </div>
                <Form style={{padding:20}} onFinish={addMenu}>
                    <h2 style={{margin: '20px',marginTop: 0}}>Додади нов запис:</h2>
                    <Form.Item
                        label="Име"
                        name="title"

                        rules={[
                            {
                                required: true,
                                message: 'Ве молиме внесете име!',
                            },
                        ]}
                    >
                        <Input/>
                    </Form.Item>
                    <Form.Item
                        label="Опис"
                        name="description"

                        rules={[
                            {
                                required: true,
                                message: 'Ве молиме внесете опис!',
                            },
                        ]}
                    >
                        <Input/>
                    </Form.Item>
                    <Form.Item
                        label="Цена"
                        name="price"

                        rules={[
                            {
                                required: true,
                                message: 'Ве молиме внесете цена!',
                            },
                        ]}
                    >
                        <Input placeholder="Цена" type={'number'}/>
                    </Form.Item>
                    <Form.Item style={{textAlign: 'center'}}>
                        <Button type="primary" htmlType="submit" loading={loadingSave}>
                            Зачувај
                        </Button>
                    </Form.Item>
                </Form>
            </div>
            <div style={{textAlign:'start'}}>
                {restaurant.menu.map(el =>
                    <Card title={el.title} extra={<p style={{color:'red',cursor:'pointer'}} onClick={()=>deleteMenu(el.id)}>Избриши</p>} style={{ width: 300, display:'inline-block', margin:'10px' }} size="small">
                        <p>{el.description}</p>
                        <b>{el.price} ден.</b>
                    </Card>
                )}
            </div>
        </div>
    )
}

export default Menu;