import React, {useEffect, useState} from 'react'
import {Button, Modal, DatePicker, List, notification, Input} from "antd";
import AddNewReservation from "./AddNewReservation";
import moment from 'moment'
import axios from "axios";
import env from '../env'

const {RangePicker} = DatePicker

const Reservations = ({}) => {
    const [newReservationModal, setNewReservationModal] = useState(false);
    const [saveModalLoading, setSaveModalLoading] = useState(false);
    const [date, setDate] = useState([moment().startOf('day'), moment().add(24,'hours')]);
    const [reservations, setReservations] = useState([])
    const [newReservations, setNewReservations] = useState([])
    const [loadingReservations, setLoadingReservations] = useState(true)

    useEffect(()=> {
        getReservations()
    },[])
    const getReservations = () =>{
        setLoadingReservations(true)
        setDate(date => {
            axios.get(env.api + 'Reservations', {
                params: {
                    from: date[0].format('YYYY-MM-DDThh:mm:ss') + 'Z',
                    to: date[1].format('YYYY-MM-DDThh:mm:ss') + 'Z'
                }, headers: {Authorization: localStorage.getItem('Auth')}
            }).then(res => {
                axios.get(env.api + 'Reservations/new', {
                     headers: {Authorization: localStorage.getItem('Auth')}
                }).then(newres=>{
                    setNewReservations(newres.data);
                    setReservations(res.data);
                    setLoadingReservations(false)
                })
            }).catch(er => {
                setLoadingReservations(false)
                notification['error']({
                    message: 'Се случи проблем при додавање резервација. Ве молиме пробајте повторно подоцна',
                });
                console.log(er);
            });
            return date;
        })
    }
    const dateChanged = (cng) => {
        setDate(cng)
        getReservations()
    }
    const changeReservationStatus = (id, newStatus) => {
        console.log(id)
        axios.put(env.api + 'Reservations/'+id+'/status',{}, {
            params: {
                status: newStatus
            }, headers: {Authorization: localStorage.getItem('Auth')}
        }).then(res => {
            getReservations()
        }).catch(er => {
            notification['error']({
                message: 'Се случи проблем при менување резервација. Ве молиме пробајте повторно подоцна',
            });
            console.log(er);
        })
    }
    const changeTable = (ev, item) => {
        axios.put(env.api + 'Reservations/'+item.id+'/table',{}, {
            params: {
                tableId: ev.target.value == '' ? 0 : ev.target.value
            }, headers: {Authorization: localStorage.getItem('Auth')}
        }).then(res => {
            console.log("success");
        }).catch(er => {
            notification['error']({
                message: 'Се случи проблем при менување резервација. Ве молиме пробајте повторно подоцна',
            });
            console.log(er);
        })
        setNewReservations(old =>{
            const newRes = old.indexOf(item);
            if(newRes == -1) return old;
            const copy = [...old];
            copy[newRes].table = ev.target.value;
            return copy;
        })
        setReservations(old =>{
            const newRes = old.indexOf(item);
            if(newRes == -1) return old;
            const copy = [...old];
            copy[newRes].table = ev.target.value;
            return copy;
        })
    }

    const ReservationType = [ 'Кратко', 'Долго', 'Настан' ];
    const ReservationPlace = [ 'Внатре', 'Надвор' ];
    const ReservationStatus = [ 'New', 'Confirmed', 'Cancelled' ];
    return(
        <div style={{padding:'20px'}}>
            <div style={{
                width: '100%',
                backgroundColor: 'white',
                padding: '20px',
                height:'75px',
                border: '1px solid lightgray'
            }} id={'expandMain'}>
                <h2 style={{float: 'left'}}>Резервации</h2>
                <Button style={{float:'right'}} type={'primary'} onClick={()=>setNewReservationModal(true)}>Нова резервација</Button>
            </div>
            <div style={{marginTop:'20px', backgroundColor:'white'}}>
                <div style={{
                    width: '100%',
                    height:'75px',
                    backgroundColor: 'white',
                    padding: '20px',
                    border: '1px solid lightgray'
                }} >
                    <h3 style={{float: 'left'}}>Нови резервации</h3>
                </div>
                <List loading={loadingReservations} dataSource={newReservations} itemLayout={'horizontal'} locale={{emptyText:'Немате нови резервации'}}
                      renderItem={item => (
                          <List.Item
                              actions={
                                  item.reservationStatus == 0 ?
                                      [<a onClick={()=>changeReservationStatus(item.id,ReservationStatus[1])}>Прифати</a>, <a style={{color:'red'}} onClick={()=>changeReservationStatus(item.id,ReservationStatus[2])}>Отфрли</a>]
                                      : item.reservationStatus == 1 ? [<span style={{color:'green'}}>Прифатено</span>] : [<span style={{color:'red'}}>Отфрлено</span>]}>
                              <div style={{display:'flex',flexDirection:'row',justifyContent:'space-between',width:'100%', padding:'10px'}}>
                                  <div style={{textAlign:'start', width:'200px'}}>
                                      <div><b>Име:</b> {item.contactName}</div>
                                      <div><b>Број:</b> {item.contactNumber}</div>
                                  </div>
                                  <div style={{marginTop:'10px'}}>
                                      Маса: <Input style={{ width: '60px' }} type={'number'} value={item.table == 0 ? '' : item.table} onChange={(ev)=>changeTable(ev,item)}/>
                                  </div>
                                  <div>
                                      <div><b>Луѓе:</b> {item.persons}</div>
                                      <div>{ReservationPlace[item.reservationPlace]}, {ReservationType[item.reservationType]}</div>
                                  </div>
                                  <div>
                                      <div style={{marginTop:'10px'}}>{moment(item.startDate).format('hh:mm DD/MM/YY')}</div>
                                  </div>
                              </div>
                          </List.Item>
                      )}/>
            </div>
            <div style={{marginTop:'20px', backgroundColor:'white'}}>
                <div style={{
                    width: '100%',
                    height:'75px',
                    backgroundColor: 'white',
                    padding: '20px',
                    border: '1px solid lightgray'
                }} >
                    <h3 style={{float: 'left'}}>Сите резервации</h3>
                    <RangePicker
                        onChange={dateChanged}
                        style={{float:'right'}}
                        ranges={{
                            'Наредни 3 часа': [moment(), moment().add(3,'hours')],
                            'Следни 24 часа': [moment().startOf('day'), moment().add(24,'hours')],
                            'Овој месец': [moment().startOf('month'), moment().endOf('month')],
                            'Последни 30 дена': [moment().subtract(30, 'days'), moment()],
                        }}
                        defaultValue={date}
                    />
                </div>
                <List loading={loadingReservations} dataSource={reservations} itemLayout={'horizontal'} locale={{emptyText:'Нема резервации за овој период'}}
                      renderItem={item => (
                          <List.Item
                              actions={
                                  item.reservationStatus == 0 ?
                                      [<a onClick={()=>changeReservationStatus(item.id,ReservationStatus[1])}>Прифати</a>, <a style={{color:'red'}} onClick={()=>changeReservationStatus(item.id,ReservationStatus[2])}>Отфрли</a>]
                                      : item.reservationStatus == 1 ? [<span style={{color:'green'}}>Прифатено</span>] : [<span style={{color:'red'}}>Отфрлено</span>]}>
                            <div style={{display:'flex',flexDirection:'row',justifyContent:'space-between',width:'100%', padding:'10px'}}>
                                <div style={{textAlign:'start', width:'200px'}}>
                                    <div><b>Име:</b> {item.contactName}</div>
                                    <div><b>Број:</b> {item.contactNumber}</div>
                                </div>
                                <div style={{marginTop:'10px'}}>
                                    Маса: <Input style={{ width: '60px' }} type={'number'} value={item.table == 0 ? '' : item.table} onChange={(ev)=>changeTable(ev,item)}/>
                                </div>
                                <div>
                                    <div><b>Луѓе:</b> {item.persons}</div>
                                    <div>{ReservationPlace[item.reservationPlace]}, {ReservationType[item.reservationType]}</div>
                                </div>
                                <div>
                                    <div style={{marginTop:'10px'}}>{moment(item.startDate).format('hh:mm DD/MM/YY')}</div>
                                </div>
                            </div>
                          </List.Item>
                      )}/>
            </div>
            <Modal
                style={{top: 20}}
                width={'700px'}
                title="Нова Резервација"
                footer={[
                    <Button form="newResForm" key="submit" htmlType="submit" type={'primary'} loading={saveModalLoading}>
                        Прати
                    </Button>
                ]}
                onCancel={()=>setNewReservationModal(false)}
                visible={newReservationModal}>
                <AddNewReservation setModalSaveLoading={setSaveModalLoading} setModalVisible={setNewReservationModal} fetchData={getReservations}/>
            </Modal>
        </div>
    )
}

export default Reservations;